#include <Python.h>
#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include "LMShid.h"
#define FALSE 0
#define TRUE !FALSE
#define VERBOSE 0
#define WRAPPERVERSION "0.1"

/* --------------------------- Version history ---------------------------
   2017-07-25   HME  Initial coding, version 0.1 using C library 1.02
*/

/* ---------------------------- Begin test case ---------------------------- */
/* This is a test case to play with passing lists. It's called in Python
like this:

   import my_module

   testlist = [1, 2, 3, 4, 5]
   print("List before multiplying = ",testlist)
   my_module.timesTwo(testlist)
   print("List after multiplying = ",testlist)
*/

static PyObject* LMS_module_timesTwo(PyObject *self, PyObject *args)
{
  int i, numLines;
  PyObject *listObj, *numObj;
  unsigned int n;

  n = PyTuple_Size(args);
  if (1 == n) {
    /* argument 1 should be an list of integers */
    listObj = PyTuple_GetItem(args, 0);
    /* get the number of elements in the list */
    numLines = PyList_Size(listObj);
#if VERBOSE
    printf("We have %d elements\r\n", numLines);
#endif
    
    /* should raise an error here. */
    if (numLines < 0)   return NULL; /* Not a list */

    for (i=0; i<numLines; i++) {
      numObj = PyList_GetItem(listObj, i);
      n = PyLong_AsLong(PyNumber_Long(numObj));
#if VERBOSE
      printf("Element %d is %d", i, n);
#endif
      // This is the action - multiply by 2 for the test case
      n = n * 2;
#if VERBOSE
      printf(" and multiplied by 2 = %d\r\n", n);
#endif
      PyList_SetItem(listObj, i, Py_BuildValue("i", n));
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "Function expects one argument");
      return NULL;
  }
  return PyLong_FromLong(1);
}
/* ---------------------------- End test case ---------------------------- */

// A module that takes no arguments
static PyObject* LMS_module_print_hello_world(PyObject *self, PyObject *args)
{
  printf("LMS sez: Hello World\r\n");
  Py_RETURN_NONE;
}

//Actual module method definition - this is the code that will be called by
//hello_module.count_to_n
static PyObject* LMS_module_count_to_n(PyObject *self, PyObject *args)
{
  int i,n;
  PyObject *temp_p;

  n = 10;  // in case we don't get any args we like
  
#if VERBOSE
  printf("I think you sent me %d args?\r\n", PyTuple_Size(args));
#endif
  for (i=0; i<PyTuple_Size(args); i++) {
    temp_p = PyTuple_GetItem(args, i);
    if (1 == PyNumber_Check(temp_p)) {
      n = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg %d is %d\r\n", i, n);
#endif
    } else
#if VERBOSE
      printf("arg %d is not a number!\r\n", i);
#else
    i = i + 0;  // we need something here to keep the processor happy.
#endif
  }
  printf("Shall we count to %d?\r\n", n);
  for (i=1; i<n+1; i++) {
    printf("%d ", i);
  }
  printf("\r\n");
  Py_RETURN_NONE;
}

/* This is the Vaunix-specific stuff. */
//void fnLMS_Init(void);
// A module that takes no arguments
static PyObject* LMS_module_fnLMS_Init(PyObject *self, PyObject *args)
{
  fnLMS_Init();
  Py_RETURN_NONE;
}

//void fnLMS_SetTestMode(bool testmode);
static PyObject* LMS_module_fnLMS_SetTestMode(PyObject *self, PyObject *args)
{
  int n;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetTestMode sez: arg 1 is devid %d\r\n", devid);
#endif
      fnLMS_SetTestMode(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetTestMode expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetTestMode expects one argument");
      return NULL;
  }
  Py_RETURN_NONE;
}

//int fnLMS_GetNumDevices();
// A module that takes no arguments
static PyObject* LMS_module_fnLMS_GetNumDevices(PyObject *self, PyObject *args)
{
  int n;
  n = fnLMS_GetNumDevices();
  return PyLong_FromLong(n);
}

//int fnLMS_GetDevInfo(DEVID *ActiveDevices)
static PyObject* LMS_module_fnLMS_GetDevInfo(PyObject *self, PyObject *args)
{
  int i, n, numElements, result;
  PyObject *listObj, *numObj;
  unsigned int cActiveDevices[MAXDEVICES];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) {
    /* argument 1 should be an list of integers */
    listObj = PyTuple_GetItem(args, 0);
    /* get the number of lines passed to us */
    numElements = PyList_Size(listObj);

    /* should raise an error here. */
    if (numElements < 0)   return NULL; /* Not a list */
    if (numElements > MAXDEVICES) numElements = MAXDEVICES; /* Limit the number of devices to match the MAXDEVICES */
#if VERBOSE
    printf("The list has %d elements\r\n", numElements);
#endif
    
    for (i=0; i<numElements; i++) {
      numObj = PyList_GetItem(listObj, i);
      cActiveDevices[i] = PyLong_AsUnsignedLong(PyNumber_Long(numObj));
#if VERBOSE
      printf("Before, element %d is %d\r\n", i, cActiveDevices[i]);
#endif
    }
    result = fnLMS_GetDevInfo(cActiveDevices);
    
    for (i=0; i<numElements; i++) {
      PyList_SetItem(listObj, i, Py_BuildValue("i", cActiveDevices[i]));
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetDevInfo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLMS_GetModelName(DEVID deviceID, char *ModelName);
static PyObject* LMS_module_fnLMS_GetModelName(PyObject *self, PyObject *args)
{
  int n;
  unsigned int devid;
  PyObject *temp_p;
  char ModelName[64];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetModelName sez: arg 1  is devid %d\r\n", devid);
#endif
      //result = fnLMS_GetModelName(i, ModelName);
      fnLMS_GetModelName(devid, ModelName);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetModelName expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetModelName expects one argument");
      return NULL;
  }
  return PyBytes_FromString(ModelName);
}


//int fnLMS_InitDevice(DEVID deviceID);
static PyObject* LMS_module_fnLMS_InitDevice(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("InitDevice sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_InitDevice(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_InitDevice expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_InitDevice expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLMS_CloseDevice(DEVID deviceID);
static PyObject* LMS_module_fnLMS_CloseDevice(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("CloseDevice sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_CloseDevice(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_CloseDevice expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_CloseDevice expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLMS_GetSerialNumber(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetSerialNumber(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetSerialNumber sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetSerialNumber(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetSerialNumber expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetSerialNumber expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLMS_SetFrequency(DEVID deviceID, int frequency);
static PyObject* LMS_module_fnLMS_SetFrequency(PyObject *self, PyObject *args)
{
  int n, result, freq;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetFrequency sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFrequency expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      freq = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is freq %d\r\n", freq);
#endif
      result = fnLMS_SetFrequency(devid, freq);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFrequency expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFrequency expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetStartFrequency(DEVID deviceID, int startfrequency);
static PyObject* LMS_module_fnLMS_SetStartFrequency(PyObject *self, PyObject *args)
{
  int n, result, freq;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetStartFrequency sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetStartFrequency expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      freq = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is freq %d\r\n", freq);
#endif
      result = fnLMS_SetStartFrequency(devid, freq);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetStartFrequency expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetStartFrequency expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetEndFrequency(DEVID deviceID, int endfrequency);
static PyObject* LMS_module_fnLMS_SetEndFrequency(PyObject *self, PyObject *args)
{
  int n, result, freq;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetEndFrequency sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetEndFrequency expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      freq = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is freq %d\r\n", freq);
#endif
      result = fnLMS_SetEndFrequency(devid, freq);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetEndFrequency expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetEndFrequency expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetSweepTime(DEVID deviceID, int sweeptime);
static PyObject* LMS_module_fnLMS_SetSweepTime(PyObject *self, PyObject *args)
{
  int n, result, sweep;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetSweepTime sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      sweep = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is sweep %d\r\n", sweep);
#endif
      result = fnLMS_SetSweepTime(devid, sweep);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLMS_SetPowerLevel(DEVID deviceID, int powerlevel);
static PyObject* LMS_module_fnLMS_SetPowerLevel(PyObject *self, PyObject *args)
{
  int n, result, power;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("SetPowerLevel sez: I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetPowerLevel sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPowerLevel expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      power = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetPowerLevel sez: arg 2 is %d\r\n", power);
#endif
      result = fnLMS_SetPowerLevel(devid, power);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPowerLevel expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPowerLevel expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetRFOn(DEVID deviceID, bool on);
static PyObject* LMS_module_fnLMS_SetRFOn(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  bool onoff;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetRFOn sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetRFOn expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      onoff = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", onoff);
#endif
      result = fnLMS_SetRFOn(devid, onoff);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetRFOn expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetRFOn expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLMS_SetPulseOnTime(DEVID deviceID, float pulseontime);
static PyObject* LMS_module_fnLMS_SetPulseOnTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  float pulsetime;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetPulseOnTime sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPulseOnTime expects an integer and a float as arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyFloat_Check(temp_p)) {
      pulsetime = PyFloat_AsDouble(PyNumber_Float(temp_p));
#if VERBOSE
      printf("arg 2 is %f\r\n", pulsetime);
#endif
      result = fnLMS_SetPulseOnTime(devid, pulsetime);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPulseOnTime expects an integer and a float as arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPulseOnTime expects an integer and a float as arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetPulseOffTime(DEVID deviceID, float pulseofftime);
static PyObject* LMS_module_fnLMS_SetPulseOffTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  float pulsetime;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetPulseOffTime sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPulseOffTime expects an integer and a float as arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyFloat_Check(temp_p)) {
      pulsetime = PyFloat_AsDouble(PyNumber_Float(temp_p));
#if VERBOSE
      printf("arg 2 is %f\r\n", pulsetime);
#endif
      result = fnLMS_SetPulseOffTime(devid, pulsetime);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPulseOffTime expects an integer and a float as arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetPulseOffTime expects an integer and a float as arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetFastPulsedOutput(DEVID deviceID, float pulseontime, float pulsereptime, bool on);
static PyObject* LMS_module_fnLMS_SetFastPulsedOutput(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  float pulsetime, pulsereptime;
  bool onoff;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (4 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetFastPulsedOutput sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFastPulsedOutput expects an integer, 2 floats and a boolean as arguments");
      return NULL;
    }
    // second argument
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyFloat_Check(temp_p)) {
      pulsetime = PyFloat_AsDouble(PyNumber_Float(temp_p));
#if VERBOSE
      printf("arg 2 is %f\r\n", pulsetime);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFastPulsedOutput expects an integer, 2 floats and a boolean as arguments");
      return NULL;
    }
    // third argument
    temp_p = PyTuple_GetItem(args, 2);
    if (1 == PyFloat_Check(temp_p)) {
      pulsereptime = PyFloat_AsDouble(PyNumber_Float(temp_p));
#if VERBOSE
      printf("arg 3 is %f\r\n", pulsereptime);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFastPulsedOutput expects an integer, 2 floats and a boolean as arguments");
      return NULL;
    }
    // fourth argument
    temp_p = PyTuple_GetItem(args, 3);
    if (1 == PyNumber_Check(temp_p)) {
      onoff = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 4 is %d\r\n", onoff);
#endif
      result = fnLMS_SetFastPulsedOutput(devid, pulsetime, pulsereptime, onoff);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFastPulsedOutput expects an integer, 2 floats and a boolean as arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetFastPulsedOutput expects an integer, 2 floats and a boolean as arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_EnableInternalPulseMod(DEVID deviceID, bool on);
static PyObject* LMS_module_fnLMS_EnableInternalPulseMod(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  bool onoff;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("EnableInternalPulseMod sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_EnableInternalPulseMod expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      onoff = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", onoff);
#endif
      result = fnLMS_EnableInternalPulseMod(devid, onoff);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_EnableInternalPulseMod expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_EnableInternalPulseMod expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetUseExternalPulseMod(DEVID deviceID, bool external);
static PyObject* LMS_module_fnLMS_SetUseExternalPulseMod(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  bool onoff;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetUseExternalPulseMod sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseExternalPulseMod expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      onoff = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", onoff);
#endif
      result = fnLMS_SetUseExternalPulseMod(devid, onoff);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseExternalPulseMod expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseExternalPulseMod expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetUseInternalRef(DEVID deviceID, bool internal);
static PyObject* LMS_module_fnLMS_SetUseInternalRef(PyObject *self, PyObject *args)
{
  int n, result, internal;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetUseInternalRef sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseInternalRef expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      internal = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", internal);
#endif
      result = fnLMS_SetUseInternalRef(devid, internal);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseInternalRef expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseInternalRef expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetUseExtSweepTrigger(DEVID deviceID, bool external);
static PyObject* LMS_module_fnLMS_SetUseExtSweepTrigger(PyObject *self, PyObject *args)
{
  int n, result, external;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetUseExtSweepTrigger sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseExtSweepTrigger expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      external = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", external);
#endif
      result = fnLMS_SetUseExtSweepTrigger(devid, external);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseExtSweepTrigger expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetUseExtSweepTrigger expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetSweepDirection(DEVID deviceID, bool up);
static PyObject* LMS_module_fnLMS_SetSweepDirection(PyObject *self, PyObject *args)
{
  int n, result, updown;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetSweepDirection sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepDirection expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      updown = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", updown);
#endif
      result = fnLMS_SetSweepDirection(devid, updown);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepDirection expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepDirection expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetSweepMode(DEVID deviceID, bool mode);
static PyObject* LMS_module_fnLMS_SetSweepMode(PyObject *self, PyObject *args)
{
  int n, result, mode;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetSweepMode sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepMode expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      mode = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", mode);
#endif
      result = fnLMS_SetSweepType(devid, mode);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepMode expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepMode expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SetSweepType(DEVID deviceID, bool swptype);
static PyObject* LMS_module_fnLMS_SetSweepType(PyObject *self, PyObject *args)
{
  int n, result, swptype;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetSweepType sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepType expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      swptype = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", swptype);
#endif
      result = fnLMS_SetSweepType(devid, swptype);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepType expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SetSweepType expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_StartSweep(DEVID deviceID, bool go);
static PyObject* LMS_module_fnLMS_StartSweep(PyObject *self, PyObject *args)
{
  int n, result, go;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("StartSweep sez: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_StartSweep expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      go = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is %d\r\n", go);
#endif
      result = fnLMS_StartSweep(devid, go);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_StartSweep expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_StartSweep expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLMS_SaveSettings(DEVID deviceID);
static PyObject* LMS_module_fnLMS_SaveSettings(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SaveSettings sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_SaveSettings(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SaveSettings expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_SaveSettings expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetFrequency(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetFrequency sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetStartFrequency(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetStartFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetStartFrequency sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetStartFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetStartFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetStartFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetEndFrequency(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetEndFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetEndFrequency sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetEndFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetEndFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetEndFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetSweepTime(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetSweepTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetSweepTime sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetSweepTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetSweepTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetSweepTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLMS_GetRF_On(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetRF_On(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetRF_On sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetRF_On(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetRF_On expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetRF_On expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetUseInternalRef(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetUseInternalRef(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetUseInternalRef sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetUseInternalRef(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetUseInternalRef expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetUseInternalRef expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetUseExtSweepTrigger(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetUseExtSweepTrigger(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetUseExtSweepTrigger sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetUseExtSweepTrigger(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetUseExtSweepTrigger expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetUseExtSweepTrigger expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetPowerLevel(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetPowerLevel(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetPowerLevel sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetPowerLevel(devid);
#if VERBOSE
      printf("GetPowerLevel returned %d which should be %f\r\n", result, (float)result/4.0);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPowerLevel expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPowerLevel expects one argument");
      return NULL;
  }
#if VERBOSE
  printf("I'm going to return %#018x as a power level\r\n", result);
#endif
  return PyLong_FromLong(result);
}

//int fnLMS_GetMaxPwr(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetMaxPwr(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetMaxPwr sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetMaxPwr(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMaxPwr expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMaxPwr expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetMinPwr(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetMinPwr(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetMinPwr sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetMinPwr(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMinPwr expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMinPwr expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetMaxFreq(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetMaxFreq(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetMaxFreq sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetMaxFreq(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMaxFreq expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMaxFreq expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLMS_GetMinFreq(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetMinFreq(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetMinFreq sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetMinFreq(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMinFreq expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetMinFreq expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//float fnLMS_GetPulseOnTime(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetPulseOnTime(PyObject *self, PyObject *args)
{
  int n;
  float result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetPulseOnTime sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetPulseOnTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPulseOnTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPulseOnTime expects one argument");
      return NULL;
  }
  return PyFloat_FromDouble(result);
}

//float fnLMS_GetPulseOffTime(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetPulseOffTime(PyObject *self, PyObject *args)
{
  int n;
  float result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetPulseOffTime sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetPulseOffTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPulseOffTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPulseOffTime expects one argument");
      return NULL;
  }
  return PyFloat_FromDouble(result);
}

//int fnLMS_GetPulseMode(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetPulseMode(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetPulseMode sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetPulseMode(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPulseMode expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetPulseMode expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

#if 0
//int fnLMS_GetHasFastPulseMode(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetHasFastPulseMode(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetHasFastPulseMode sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetHasFastPulseMode(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetHasFastPulseMode expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetHasFastPulseMode expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}
#endif

//int fnLMS_GetUseInternalPulseMod(DEVID deviceID);
static PyObject* LMS_module_fnLMS_GetUseInternalPulseMod(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetUseInternalPulseMod sez: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLMS_GetUseInternalPulseMod(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetUseInternalPulseMod expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_GetUseInternalPulseMod expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//char* fnLMS_perror(LVSTATUS status);
static PyObject* LMS_module_fnLMS_perror(PyObject *self, PyObject *args)
{
  unsigned int i, n;
  PyObject *temp_p;
  char errorstring[64];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      i = 0xFFFFFFFF & PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("perror sez: arg 1 is %x\r\n", i);
#endif
      sprintf(errorstring,"%s",fnLMS_perror(i));
    } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_fnLMS_perror expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LMS_module.fnLMS_fnLMS_perror expects one argument");
      return NULL;
  }
  return PyBytes_FromString(errorstring);
}

//char* fnLMS_LibVersion(void);
static PyObject* LMS_module_fnLMS_LibVersion(PyObject *self, PyObject *args)
{
  char errorstring[64];

  sprintf(errorstring,"%s",fnLMS_LibVersion());
  return PyBytes_FromString(errorstring);
}

static PyObject* LMS_module_WrapperVersion(PyObject *self, PyObject *args)
{
  return PyBytes_FromString(WRAPPERVERSION);
}




//Method definition object for this extension, these argumens mean:
//ml_name: The name of the method
//ml_meth: Function pointer to the method implementation
//ml_flags: Flags indicating special features of this method, such as
//          accepting arguments, accepting keyword arguments, being a
//          class method, or being a static method of a class.
//ml_doc:  Contents of this method's docstring
static PyMethodDef LMS_module_methods[] = { 
    {   
        "print_hello_world",
        LMS_module_print_hello_world,
        METH_NOARGS,
        "Print 'hello world' from a method defined in a C extension."
    },  
    {   
        "count_to_n",
        LMS_module_count_to_n,
        METH_VARARGS,
        "Count to some number in a C extension."
    },  
    {   
        "timesTwo",
        LMS_module_timesTwo,
        METH_VARARGS,
        "Multiplies each element in a list by 2"
    },  
    {   
        "fnLMS_Init",
        LMS_module_fnLMS_Init,
        METH_NOARGS,
        "Set up the LMS device"
    },  
    {   
        "fnLMS_SetTestMode",
        LMS_module_fnLMS_SetTestMode,
        METH_VARARGS,
        "Set test mode if desired"
    },  
    {   
        "fnLMS_GetNumDevices",
        LMS_module_fnLMS_GetNumDevices,
        METH_NOARGS,
        "Return the number of LMS devices"
    },  
    {   
        "fnLMS_GetDevInfo",
        LMS_module_fnLMS_GetDevInfo,
        METH_VARARGS,
        "Returns a list of active devices"
    },  
    {   
        "fnLMS_GetModelName",
        LMS_module_fnLMS_GetModelName,
        METH_VARARGS,
        "Returns the name of an LMS model"
    },  
    {   
        "fnLMS_InitDevice",
        LMS_module_fnLMS_InitDevice,
        METH_VARARGS,
        "Initializes an LMS device"
    },  
    {   
        "fnLMS_CloseDevice",
        LMS_module_fnLMS_CloseDevice,
        METH_VARARGS,
        "Closes an LMS device"
    },  
    {   
        "fnLMS_GetSerialNumber",
        LMS_module_fnLMS_GetSerialNumber,
        METH_VARARGS,
        "Returns the serial of an LMS device"
    },  
    {   
        "fnLMS_SetFrequency",
        LMS_module_fnLMS_SetFrequency,
        METH_VARARGS,
        "Sets the output frequency on an LMS device"
    },  
    {   
        "fnLMS_SetStartFrequency",
        LMS_module_fnLMS_SetStartFrequency,
        METH_VARARGS,
        "Sets the start frequency for a sweep on an LMS device"
    },  
    {   
        "fnLMS_SetEndFrequency",
        LMS_module_fnLMS_SetEndFrequency,
        METH_VARARGS,
        "Sets the end frequency for a sweep on an LMS device"
    },  
    {   
        "fnLMS_SetSweepTime",
        LMS_module_fnLMS_SetSweepTime,
        METH_VARARGS,
        "Sets the sweep speed on an LMS device"
    },  
    {   
        "fnLMS_SetPowerLevel",
        LMS_module_fnLMS_SetPowerLevel,
        METH_VARARGS,
        "Sets the output power on an LMS device"
    },  
    {   
        "fnLMS_SetRFOn",
        LMS_module_fnLMS_SetRFOn,
        METH_VARARGS,
        "Enables the output on an LMS device"
    },  
    {   
        "fnLMS_SetPulseOnTime",
        LMS_module_fnLMS_SetPulseOnTime,
        METH_VARARGS,
        "Sets the LMS pulse generator on time"
    },  
    {   
        "fnLMS_SetPulseOffTime",
        LMS_module_fnLMS_SetPulseOffTime,
        METH_VARARGS,
        "Sets the LMS pulse generator off time"
    },  
    {   
        "fnLMS_SetFastPulsedOutput",
        LMS_module_fnLMS_SetFastPulsedOutput,
        METH_VARARGS,
        "Configures the LMS pulse generator for fast pulsed output"
    },  
    {   
        "fnLMS_EnableInternalPulseMod",
        LMS_module_fnLMS_EnableInternalPulseMod,
        METH_VARARGS,
        "Enables the internal LMS pulse mode"
    },  
    {   
        "fnLMS_SetUseExternalPulseMod",
        LMS_module_fnLMS_SetUseExternalPulseMod,
        METH_VARARGS,
        "Sets the LMS pulse generator for external trigger"
    },  
    {   
        "fnLMS_SetUseInternalRef",
	LMS_module_fnLMS_SetUseInternalRef,
        METH_VARARGS,
        "Sets the LMS pulse generator to use internal reference"
    },  
    {   
        "fnLMS_SetUseExtSweepTrigger",
        LMS_module_fnLMS_SetUseExtSweepTrigger,
        METH_VARARGS,
        "Sets the LMS sweep generator for external trigger"
    },  
    {   
        "fnLMS_SetSweepDirection",
        LMS_module_fnLMS_SetSweepDirection,
        METH_VARARGS,
        "Sets the LMS sweep generator direction"
    },  
    {   
        "fnLMS_SetSweepMode",
        LMS_module_fnLMS_SetSweepMode,
        METH_VARARGS,
        "Sets the LMS sweep generator mode"
    },  
    {   
        "fnLMS_SetSweepType",
        LMS_module_fnLMS_SetSweepType,
        METH_VARARGS,
        "Sets the LMS sweep generator type"
    },  
    {   
        "fnLMS_StartSweep",
        LMS_module_fnLMS_StartSweep,
        METH_VARARGS,
        "Starts the LMS sweep generator"
    },  
    {   
        "fnLMS_SaveSettings",
        LMS_module_fnLMS_SaveSettings,
        METH_VARARGS,
        "Saves the LMS settings"
    },  
    {   
        "fnLMS_GetFrequency",
        LMS_module_fnLMS_GetFrequency,
        METH_VARARGS,
        "Returns the current LMS frequency"
    },  
    {   
        "fnLMS_GetStartFrequency",
        LMS_module_fnLMS_GetStartFrequency,
        METH_VARARGS,
        "Returns the current LMS sweep start frequency"
    },  
    {   
        "fnLMS_GetEndFrequency",
        LMS_module_fnLMS_GetEndFrequency,
        METH_VARARGS,
        "Returns the current LMS sweep end frequency"
    },  
    {   
        "fnLMS_GetSweepTime",
        LMS_module_fnLMS_GetSweepTime,
        METH_VARARGS,
        "Returns the current LMS sweep time"
    },  
    {   
        "fnLMS_GetRF_On",
        LMS_module_fnLMS_GetRF_On,
        METH_VARARGS,
        "Returns the current on/off RF state"
    },  
    {   
        "fnLMS_GetUseInternalRef",
        LMS_module_fnLMS_GetUseInternalRef,
        METH_VARARGS,
        "Returns the current internal ref status"
    },  
    {   
        "fnLMS_GetUseExtSweepTrigger",
        LMS_module_fnLMS_GetUseExtSweepTrigger,
        METH_VARARGS,
        "Returns the current external sweep trigger state"
    },  
    {   
        "fnLMS_GetPowerLevel",
        LMS_module_fnLMS_GetPowerLevel,
        METH_VARARGS,
        "Returns the current LMS power output level"
    },  
    {   
        "fnLMS_GetMaxPwr",
        LMS_module_fnLMS_GetMaxPwr,
        METH_VARARGS,
        "Returns the LMS device maximum power setting"
    },  
    {   
        "fn_LMS_GetMinPwr",
        LMS_module_fnLMS_GetMinPwr,
        METH_VARARGS,
        "Returns the LMS device minimum power setting"
    },  
    {   
        "fnLMS_GetMaxFreq",
        LMS_module_fnLMS_GetMaxFreq,
        METH_VARARGS,
        "Returns the LMS device maximum frequency"
    },  
    {   
        "fnLMS_GetMinFreq",
        LMS_module_fnLMS_GetMinFreq,
        METH_VARARGS,
        "Returns the LMS device minimum frequency"
    },  
    {   
        "fnLMS_GetPulseOnTime",
        LMS_module_fnLMS_GetPulseOnTime,
        METH_VARARGS,
        "Returns the current LMS pulse generator on time"
    },  
    {   
        "fnLMS_GetPulseOffTime",
        LMS_module_fnLMS_GetPulseOffTime,
        METH_VARARGS,
        "Returns the current LMS pulse generator off time"
    },  
    {   
        "fnLMS_GetPulseMode",
        LMS_module_fnLMS_GetPulseMode,
        METH_VARARGS,
        "Returns the current LMS pulse mode"
    },  
#if 0
    {   
        "fnLMS_GetHasFastPulseMode",
        LMS_module_fnLMS_GetHasFastPulseMode,
        METH_VARARGS,
        "Returns whether the LMS device supports fast pulse mode"
    },  
#endif
    {   
        "fnLMS_GetUseInternalPulseMod",
        LMS_module_fnLMS_GetUseInternalPulseMod,
        METH_VARARGS,
        "Returns the LMS device internal pulse mode current state"
    },  
    {   
        "fnLMS_perror",
        LMS_module_fnLMS_perror,
        METH_VARARGS,
        "Converts an LMS library error to a string"
    },  
    {   
        "fnLMS_LibVersion",
        LMS_module_fnLMS_LibVersion,
        METH_NOARGS,
        "Returns the LMS library version"
    },  
    {   
        "WrapperVersion",
        LMS_module_WrapperVersion,
        METH_NOARGS,
        "Returns the LMS library wrapper version"
    },  
    {NULL, NULL, 0, NULL}
};


//Module definition
//The arguments of this structure tell Python what to call your extension,
//what it's methods are and where to look for it's method definitions
static struct PyModuleDef LMS_module_definition = { 
    PyModuleDef_HEAD_INIT,
    "LMS_module",
    "A Python module for managing the Vaunix LMS series synthesizers.",
    -1, 
    LMS_module_methods
};

//Module initialization
//Python calls this function when importing your extension. It is important
//that this function is named PyInit_[[your_module_name]] exactly, and matches
//the name keyword argument in setup.py's setup() call.
PyMODINIT_FUNC PyInit_LMS_module(void)
{
    Py_Initialize();

    return PyModule_Create(&LMS_module_definition);
}

